<?php
/**
 * Plugin Name: ShieldAIQ Security
 *  * Plugin URI: https://shieldaiq.online
 * Description: Reduce WordPress fingerprints, block brute-force attacks, and (with activated license) enable stealth admin/login protection + AI weekly summary.
 * Version: 1.3.3
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Author: ShieldAIQ
 * Author URI: https://shieldaiq.online
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: shieldaiq-security
 */
if (!defined('ABSPATH')) { exit; }

define('SHIELDAIQ_SEC_VERSION', '1.3.3');
define('SHIELDAIQ_SEC_FILE', __FILE__);
define('SHIELDAIQ_SEC_DIR', plugin_dir_path(__FILE__));
define('SHIELDAIQ_SEC_URL', plugin_dir_url(__FILE__));

require_once SHIELDAIQ_SEC_DIR . 'includes/class-utils.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-settings.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-hardening.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-firewall.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-cache.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-admin-protect.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-stealth-login.php';
require_once SHIELDAIQ_SEC_DIR . 'includes/class-ai.php';

add_action('plugins_loaded', function () {
    \ShieldAIQ\Security\Settings::init();
    \ShieldAIQ\Security\Hardening::init();
    \ShieldAIQ\Security\Firewall::init();
    \ShieldAIQ\Security\Cache::init();
    \ShieldAIQ\Security\AdminProtect::init();
    \ShieldAIQ\Security\StealthLogin::init();
    \ShieldAIQ\Security\AI::init();
});

register_activation_hook(__FILE__, function () {
    \ShieldAIQ\Security\StealthLogin::flush_rewrites();
});
register_deactivation_hook(__FILE__, function () { flush_rewrite_rules(); });
