<?php
namespace ShieldAIQ\Security;
if (!defined('ABSPATH')) { exit; }

final class Utils {
    public static function opt_key(string $key): string { return 'shieldaiq_sec_' . $key; }
    public static function get(string $key, $default=null){ return get_option(self::opt_key($key), $default); }
    public static function update(string $key, $value): bool { return update_option(self::opt_key($key), $value, false); }
    public static function sanitize_slug($slug): string {
        $slug = strtolower((string)$slug);
        $slug = preg_replace('/[^a-z0-9\-_]/', '', $slug);
        $slug = trim($slug, '-_');
        return $slug !== '' ? $slug : 'secure-login';
    }
    public static function site_host(): string {
        $host = wp_parse_url(home_url('/'), PHP_URL_HOST);
        return $host ? $host : '';
    }
    public static function ip(): string { $ip = $_SERVER['REMOTE_ADDR'] ?? ''; return is_string($ip)?$ip:''; }
    public static function log_event(string $type, string $message): void {
        $s = Settings::get_settings();
        if (empty($s['log_enabled'])) return;
        $max = max(50, min(1000, intval($s['log_max'] ?? 200)));
        $logs = get_option(self::opt_key('logs'), []);
        if (!is_array($logs)) $logs = [];
        array_unshift($logs, [
            'ts'=>time(),
            'type'=>$type,
            'msg'=>$message,
            'ip'=>self::ip(),
            'ua'=>substr((string)($_SERVER['HTTP_USER_AGENT'] ?? ''),0,220)
        ]);
        $logs = array_slice($logs, 0, $max);
        update_option(self::opt_key('logs'), $logs, false);
    }
    public static function dashicon(string $name, string $class=''): string {
        $c = $class ? ' '.esc_attr($class) : '';
        return '<span class="dashicons dashicons-'.esc_attr($name).$c.'"></span>';
    }
    public static function purge_caches(): void {
        if (class_exists('\\ShieldAIQ\\Security\\Cache')) { \ShieldAIQ\Security\Cache::purge_all(); }

        // Do NOT clear license status without re-validating; purge is for caching only.
        delete_transient('shieldaiq_ai_summary');
        if (function_exists('wp_cache_flush')) { @wp_cache_flush(); }
    }
}
