<?php
namespace ShieldAIQ\Security;
if (!defined('ABSPATH')) { exit; }

final class Hardening {
    public static function init(): void { add_action('init', [__CLASS__, 'apply']); }
    public static function apply(): void {
        $s = Settings::get_settings();
        if (!empty($s['hide_generator'])) { remove_action('wp_head','wp_generator'); add_filter('the_generator','__return_empty_string'); }
        if (!empty($s['remove_rsd'])) { remove_action('wp_head','rsd_link'); }
        if (!empty($s['remove_wlw'])) { remove_action('wp_head','wlwmanifest_link'); }
        if (!empty($s['remove_shortlink'])) { remove_action('wp_head','wp_shortlink_wp_head',10); remove_action('template_redirect','wp_shortlink_header',11); }
        if (!empty($s['disable_xmlrpc'])) { add_filter('xmlrpc_enabled','__return_false'); add_filter('xmlrpc_methods', function(){ return []; }); }
    }
}
