<?php
namespace ShieldAIQ\Security;
if (!defined('ABSPATH')) { exit; }

final class Firewall {
    public static function init(): void { add_filter('authenticate',[__CLASS__,'rate_limit_authenticate'],50,3); }
    public static function rate_limit_authenticate($user,$username,$password){
        $s = Settings::get_settings();
        if (empty($s['rate_limit_enabled'])) return $user;
        if (!self::is_login_request()) return $user;

        $ip = Utils::ip(); if ($ip==='') return $user;
        $max = intval($s['rate_limit_max'] ?? 6);
        $win = intval($s['rate_limit_window'] ?? 15);
        $key = 'shieldaiq_rl_' . md5($ip);
        $data = get_transient($key); if (!is_array($data)) $data=['count'=>0];

        if (($data['count'] ?? 0) >= $max) {
            Utils::log_event('rate_limited','Blocked login attempt (rate limit reached).');
            return new \WP_Error('shieldaiq_rate_limited', __('Too many failed login attempts. Please try again later.','shieldaiq-security'));
        }
        if (is_wp_error($user)) {
            $data['count'] = intval($data['count'] ?? 0) + 1;
            set_transient($key, $data, $win * MINUTE_IN_SECONDS);
            Utils::log_event('failed_logins','Failed login attempt ('. $data['count'] .'/'. $max .').');
        }
        return $user;
    }
    private static function is_login_request(): bool {
        $p = $GLOBALS['pagenow'] ?? '';
        if ($p === 'wp-login.php') return true;
        $uri = $_SERVER['REQUEST_URI'] ?? '';
        return is_string($uri) && (strpos($uri,'wp-login.php') !== false);
    }
}
