<?php
namespace ShieldAIQ\Security;
if (!defined('ABSPATH')) { exit; }

final class AdminProtect {
    public static function init(): void { add_action('init',[__CLASS__,'maybe_protect_admin'],1); }

    public static function maybe_protect_admin(): void {
        if (is_user_logged_in()) return;
        $uri = $_SERVER['REQUEST_URI'] ?? '';
        if (is_string($uri) && strpos($uri,'admin-ajax.php') !== false) return;

        $s = Settings::get_settings();
        if (empty($s['protect_admin_logged_out'])) return;

        if (!is_string($uri) || strpos($uri,'/wp-admin') === false) return;

        // If stealth wants to block wp-admin, stealth handler will enforce 404.
        if (StealthLogin::should_enforce_stealth() && !empty($s['block_wp_admin'])) return;

        $mode = $s['admin_block_mode'] ?? 'login';
        if ($mode === '404') { status_header(404); nocache_headers(); exit; }
        if ($mode === 'home') { wp_safe_redirect(home_url('/')); exit; }
        wp_safe_redirect(wp_login_url()); exit;
    }
}
