<?php get_header(); ?>

<main class="brandaiq-container" style="padding:55px 0 70px">
  <?php while (have_posts()) { the_post(); ?>
    <article <?php post_class('brandaiq-post'); ?>>
      <header class="brandaiq-post-hero">
        <p class="brandaiq-post-meta">
          <?php echo esc_html(get_the_date()); ?>
          <span aria-hidden="true">•</span>
          <?php echo esc_html(get_the_author()); ?>
        </p>
        <h1 class="brandaiq-post-title"><?php the_title(); ?></h1>
      </header>

      <?php if (has_post_thumbnail()) { ?>
        <div class="brandaiq-post-thumb">
          <?php the_post_thumbnail('large', ['loading' => 'lazy']); ?>
        </div>
      <?php } ?>

      <div class="brandaiq-post-content">
        <?php the_content(); ?>
      </div>

      <footer class="brandaiq-post-footer">
        <?php the_tags('<div class="brandaiq-tags"><strong>'.esc_html__('Tags:', 'brandaiq').'</strong> ', ', ', '</div>'); ?>
      </footer>
    </article>
  <?php } ?>
</main>

<?php get_footer(); ?>
