<?php
/**
 * Template Name: Blog (BrandAIQ)
 * Description: Lists recent blog posts.
 */
get_header();
?>
<main class="brandaiq-page">
  <section class="brandaiq-hero-simple">
    <div class="brandaiq-container">
      <h1><?php echo esc_html(get_the_title()); ?></h1>
      <p class="brandaiq-muted"><?php echo esc_html(get_bloginfo('description')); ?></p>
    </div>
  </section>

  <section class="brandaiq-section">
    <div class="brandaiq-container">
      <?php
      $paged = max(1, get_query_var('paged'));
      $q = new WP_Query([
        'post_type' => 'post',
        'posts_per_page' => 10,
        'paged' => $paged
      ]);
      if ($q->have_posts()):
        echo '<div class="brandaiq-blog-grid">';
        while ($q->have_posts()): $q->the_post();
          ?>
          <article class="brandaiq-card brandaiq-blog-card">
            <a class="brandaiq-blog-thumb" href="<?php the_permalink(); ?>" aria-label="<?php the_title_attribute(); ?>">
              <?php if (has_post_thumbnail()) { the_post_thumbnail('large'); } ?>
            </a>
            <div class="brandaiq-card-body">
              <div class="brandaiq-blog-meta"><?php echo esc_html(get_the_date()); ?> • <?php echo esc_html(get_the_author()); ?></div>
              <h2 class="brandaiq-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
              <p class="brandaiq-blog-excerpt"><?php echo esc_html(wp_trim_words(get_the_excerpt(), 26)); ?></p>
              <a class="brandaiq-link" href="<?php the_permalink(); ?>">Read more →</a>
            </div>
          </article>
          <?php
        endwhile;
        echo '</div>';
        ?>
        <div class="brandaiq-pagination">
          <?php
          echo paginate_links([
            'total' => $q->max_num_pages,
            'current' => $paged
          ]);
          ?>
        </div>
        <?php
        wp_reset_postdata();
      else:
        echo '<p>No posts yet.</p>';
      endif;
      ?>
    </div>
  </section>
</main>
<?php get_footer(); ?>
