<?php
get_header();

if (is_search()) {
  $title = sprintf(__('Search results for: %s', 'brandaiq'), get_search_query());
  $desc  = '';
} elseif (is_archive()) {
  $title = get_the_archive_title();
  $desc  = get_the_archive_description();
} else {
  $title = __('Blog', 'brandaiq');
  $desc  = get_bloginfo('description');
}
?>

<main class="brandaiq-container" style="padding:55px 0 70px">
  <header class="brandaiq-blog-hero">
    <h1><?php echo esc_html(wp_strip_all_tags($title)); ?></h1>
    <?php if (!empty($desc)) : ?>
      <p><?php echo wp_kses_post($desc); ?></p>
    <?php endif; ?>
  </header>

  <section class="brandaiq-blog-grid">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
      <article class="brandaiq-blog-card">
        <a class="brandaiq-blog-thumb" href="<?php the_permalink(); ?>" aria-label="<?php the_title_attribute(); ?>">
          <?php if (has_post_thumbnail()) : ?>
            <?php the_post_thumbnail('large', ['loading' => 'lazy']); ?>
          <?php else : ?>
            <div class="brandaiq-blog-thumb--placeholder"></div>
          <?php endif; ?>
        </a>
        <div class="brandaiq-blog-card-body">
          <div class="brandaiq-blog-meta">
            <span><?php echo esc_html(get_the_date()); ?></span>
            <span aria-hidden="true">•</span>
            <span><?php echo esc_html(get_the_author()); ?></span>
          </div>
          <h2 class="brandaiq-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
          <p class="brandaiq-blog-excerpt"><?php echo esc_html(wp_trim_words(get_the_excerpt() ?: wp_strip_all_tags(get_the_content()), 22)); ?></p>
          <a class="brandaiq-blog-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'brandaiq'); ?> →</a>
        </div>
      </article>
    <?php endwhile; else : ?>
      <p><?php esc_html_e('Nothing found.', 'brandaiq'); ?></p>
    <?php endif; ?>
  </section>

  <div class="brandaiq-blog-pagination">
    <?php
      the_posts_pagination([
        'mid_size'  => 1,
        'prev_text' => __('← Previous', 'brandaiq'),
        'next_text' => __('Next →', 'brandaiq'),
      ]);
    ?>
  </div>
</main>

<?php get_footer(); ?>
