<?php
if (!defined('ABSPATH')) exit;

function brandaiq_opt($key, $default='') {
  $opt = (array) get_option('brandaiq_company', []);
  return $opt[$key] ?? $default;
}

add_shortcode('brandaiq_phone', fn()=>esc_html(brandaiq_opt('phone','')));
add_shortcode('brandaiq_email', fn()=>esc_html(brandaiq_opt('email','')));
add_shortcode('brandaiq_address', fn()=>esc_html(brandaiq_opt('address','')));

add_shortcode('brandaiq_hero', function(){
  $title = brandaiq_opt('hero_title','Plumbers. We Get It Right.');
  $sub = brandaiq_opt('hero_subtitle','Fast, reliable plumbing services with honest pricing. Same-day appointments available.');
  $btn_text = brandaiq_opt('hero_button_text','Get Free Quote');
  $btn_url = brandaiq_opt('hero_button_url','/contact');

  $bg_id = (int) brandaiq_opt('hero_bg_image_id','');
  $bg = $bg_id ? wp_get_attachment_image_url($bg_id, 'full') : '';

  $person_id = (int) brandaiq_opt('hero_person_image_id','');
  $person = $person_id ? wp_get_attachment_image_url($person_id, 'full') : '';

  $phone = brandaiq_opt('phone','');
  $tel = preg_replace('/[^0-9\+]/','', $phone);

  ob_start(); ?>
  <section class="brandaiq-hero" <?php echo $bg ? 'style="--hero-bg:url('.esc_url($bg).')"' : ''; ?>>
    <div class="brandaiq-hero__bg" aria-hidden="true"></div>

    <div class="brandaiq-hero__wrap">
      <div class="brandaiq-hero__card">
        <div class="brandaiq-hero__badge">
          <span class="dashicons dashicons-warning"></span>
          <span><strong>Emergency?</strong> Call now!</span>
        </div>

        <h1 class="brandaiq-hero__title"><?php echo esc_html($title); ?></h1>
        <p class="brandaiq-hero__subtitle"><?php echo esc_html($sub); ?></p>

        <div class="brandaiq-hero__actions">
          <a class="brandaiq-btn brandaiq-btn--dark" href="<?php echo esc_url($btn_url); ?>"><?php echo esc_html($btn_text); ?></a>
          <?php if ($tel): ?>
            <a class="brandaiq-btn brandaiq-btn--accent" href="tel:<?php echo esc_attr($tel); ?>">
              <span class="dashicons dashicons-phone"></span> Call Now
            </a>
          <?php endif; ?>
        </div>

        <div class="brandaiq-hero__meta">
          <span class="dashicons dashicons-shield"></span> Licensed & Insured
          <span class="brandaiq-dot">•</span>
          <span class="dashicons dashicons-clock"></span> 24/7 Emergency
        </div>
      </div>

      <?php if ($person): ?>
        <div class="brandaiq-hero__person" aria-hidden="true">
          <img src="<?php echo esc_url($person); ?>" alt="">
        </div>
      <?php endif; ?>
    </div>
  </section>
  <?php
  return ob_get_clean();
});
add_shortcode('brandaiq_services', function(){
  $raw = (string) brandaiq_opt('services','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  if (!$arr) return '';

  ob_start(); ?>
  <div class="brandaiq-services">
    <?php foreach ($arr as $s):
      $icon = sanitize_key($s['icon'] ?? 'admin-tools');
      ?>
      <div class="brandaiq-service-card">
        <span class="dashicons dashicons-<?php echo esc_attr($icon); ?>"></span>
        <h3><?php echo esc_html($s['title'] ?? ''); ?></h3>
        <p><?php echo esc_html($s['desc'] ?? ''); ?></p>
      </div>
    <?php endforeach; ?>
  </div>
  <?php return ob_get_clean();
});

add_shortcode('brandaiq_contact_form', function(){
  $sent = false; $err = '';
  if (!empty($_POST['brandaiq_cf']) && wp_verify_nonce($_POST['brandaiq_cf'], 'brandaiq_contact')) {
    $name = sanitize_text_field($_POST['name'] ?? '');
    $email = sanitize_email($_POST['email'] ?? '');
    $phone = sanitize_text_field($_POST['phone'] ?? '');
    $msg = sanitize_textarea_field($_POST['message'] ?? '');

    if (!$email || !$msg) {
      $err = 'Please provide a valid email and message.';
    } else {
      $to = brandaiq_opt('email', get_option('admin_email'));
      $subject = 'New quote request from ' . ($name ?: 'Website');
      $body = "Name: $name\nEmail: $email\nPhone: $phone\n\nMessage:\n$msg\n";
      $headers = ['Reply-To: ' . $email];
      wp_mail($to, $subject, $body, $headers);
      $sent = true;
    }
  }

  ob_start(); ?>
  <div class="brandaiq-form">
    <?php if ($sent): ?>
      <div class="brandaiq-alert brandaiq-alert--ok">Thanks! We’ll contact you shortly.</div>
    <?php elseif ($err): ?>
      <div class="brandaiq-alert brandaiq-alert--err"><?php echo esc_html($err); ?></div>
    <?php endif; ?>

    <form method="post">
      <input type="hidden" name="brandaiq_cf" value="<?php echo esc_attr(wp_create_nonce('brandaiq_contact')); ?>">
      <div class="brandaiq-form-grid">
        <label>Name
          <input name="name" type="text" placeholder="Your name">
        </label>
        <label>Email *
          <input name="email" type="email" placeholder="you@email.com" required>
        </label>
        <label>Phone
          <input name="phone" type="text" placeholder="(555) 123-4567">
        </label>
      </div>
      <label>Message *
        <textarea name="message" rows="5" placeholder="Tell us what you need..." required></textarea>
      </label>
      <button class="brandaiq-btn brandaiq-btn--dark" type="submit">Send Request</button>
    </form>
  </div>
  <?php return ob_get_clean();
});


add_shortcode('brandaiq_testimonials', function(){
  $enabled = brandaiq_opt('testimonials_enabled','1') === '1';
  if (!$enabled) return '';
  $count = absint(brandaiq_opt('testimonials_count','3'));
  if (!in_array($count, [3,5], true)) $count = 3;

  $raw = (string) brandaiq_opt('testimonials','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  $arr = array_values($arr);
  if (!$arr) return '';

  $show = array_slice($arr, 0, $count);

  ob_start(); ?>
  <section class="brandaiq-section">
    <div class="brandaiq-section-head">
      <h2>What Customers Say</h2>
      <p>Real homeowners. Real results.</p>
    </div>
    <div class="brandaiq-testimonials">
      <?php foreach($show as $t): ?>
        <div class="brandaiq-tile">
          <p>“<?php echo esc_html((string)($t['quote'] ?? '')); ?>”</p>
          <p><strong>— <?php echo esc_html((string)($t['name'] ?? '')); ?></strong></p>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
});



add_shortcode('brandaiq_why', function(){
  if (brandaiq_opt('why_enabled','1') !== '1') return '';
  $raw = (string) brandaiq_opt('why_items','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  if (!$arr) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-why">
    <div class="brandaiq-section-head">
      <h2>Why To Choose Our Services</h2>
      <p>Professional work, fair pricing, and fast response when you need it.</p>
    </div>
    <div class="brandaiq-why-grid">
      <?php foreach($arr as $it): ?>
        <div class="brandaiq-why-item">
          <span class="dashicons dashicons-hammer"></span>
          <div>
            <strong><?php echo esc_html((string)($it['title'] ?? '')); ?></strong>
            <p><?php echo esc_html((string)($it['text'] ?? '')); ?></p>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
});




add_shortcode('brandaiq_info', function(){
  if (brandaiq_opt('info_enabled','1') !== '1') return '';
  $raw = (string) brandaiq_opt('info_items','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  if (!$arr) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-info">
    <div class="brandaiq-info-grid">
      <?php foreach($arr as $it): ?>
        <div class="brandaiq-info-item">
          <h3><?php echo esc_html((string)($it['title'] ?? '')); ?></h3>
          <p><?php echo esc_html((string)($it['text'] ?? '')); ?></p>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
});




add_shortcode('brandaiq_team', function(){
  if (brandaiq_opt('team_enabled','0') !== '1') return '';
  $raw = (string) brandaiq_opt('team_items','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  if (!$arr) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-team">
    <div class="brandaiq-section-head">
      <h2>Meet Our Team</h2>
      <p>Friendly, experienced technicians ready to help.</p>
    </div>
    <div class="brandaiq-team-grid">
      <?php foreach($arr as $m): 
        $pid = absint($m['photo_id'] ?? 0);
        $url = $pid ? wp_get_attachment_image_url($pid,'medium') : '';
        ?>
        <div class="brandaiq-team-card">
          <div class="brandaiq-team-photo">
            <?php if($url): ?><img src="<?php echo esc_url($url); ?>" alt=""><?php else: ?><div class="brandaiq-team-ph"></div><?php endif; ?>
          </div>
          <div class="brandaiq-team-meta">
            <strong><?php echo esc_html((string)($m['name'] ?? '')); ?></strong>
            <span><?php echo esc_html((string)($m['role'] ?? '')); ?></span>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
});




add_shortcode('brandaiq_map', function(){
  if (brandaiq_opt('map_enabled','0') !== '1') return '';
  $embed = (string) brandaiq_opt('map_embed','');
  if (!$embed) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-map">
    <div class="brandaiq-section-head">
      <h2>Service Area Map</h2>
      <p>We serve nearby neighborhoods and surrounding cities.</p>
    </div>
    <div class="brandaiq-map-embed"><?php echo $embed; ?></div>
  </section>
  <?php return ob_get_clean();
});




add_shortcode('brandaiq_social', function(){
  if (brandaiq_opt('social_enabled','1') !== '1') return '';
  $raw = (string) brandaiq_opt('social_items','[]');
  $arr = json_decode($raw, true);
  if (!is_array($arr)) $arr = [];
  if (!$arr) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-social">
    <div class="brandaiq-social-row">
      <h3>Follow Us</h3>
      <div class="brandaiq-social-links">
        <?php foreach($arr as $s):
          $label = (string)($s['label'] ?? '');
          $url = (string)($s['url'] ?? '');
          if(!$label || !$url) continue;
        ?>
          <a class="brandaiq-social-link" href="<?php echo esc_url($url); ?>" rel="noopener" target="_blank"><?php echo esc_html($label); ?></a>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
  <?php return ob_get_clean();
});




add_shortcode('brandaiq_call_banner', function(){
  if (brandaiq_opt('call_banner_enabled','1') !== '1') return '';
  $phone = brandaiq_opt('phone','');
  $tel = preg_replace('/[^0-9\+]/','', $phone);
  if(!$tel) return '';
  ob_start(); ?>
  <section class="brandaiq-call-banner">
    <div class="brandaiq-container brandaiq-call-banner-inner">
      <div>
        <strong>Need a plumber today?</strong>
        <span>Call now for fast service and same-day appointments.</span>
      </div>
      <a class="brandaiq-btn brandaiq-btn--accent" href="tel:<?php echo esc_attr($tel); ?>">Call <?php echo esc_html($phone); ?></a>
    </div>
  </section>
  <?php return ob_get_clean();
});



/**
 * Blog index shortcode used for demo Blog page.
 */
function brandaiq_blog_index_shortcode() {
  ob_start();
  // Use the Blog template layout if this shortcode is used inside a normal page.
  $paged = max(1, get_query_var('paged'));
  $q = new WP_Query([
    'post_type' => 'post',
    'posts_per_page' => 10,
    'paged' => $paged
  ]);
  ?>
  <div class="brandaiq-blog-grid">
    <?php if ($q->have_posts()): while ($q->have_posts()): $q->the_post(); ?>
      <article class="brandaiq-card brandaiq-blog-card">
        <a class="brandaiq-blog-thumb" href="<?php the_permalink(); ?>" aria-label="<?php the_title_attribute(); ?>">
          <?php if (has_post_thumbnail()) { the_post_thumbnail('large'); } ?>
        </a>
        <div class="brandaiq-card-body">
          <div class="brandaiq-blog-meta"><?php echo esc_html(get_the_date()); ?> • <?php echo esc_html(get_the_author()); ?></div>
          <h2 class="brandaiq-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
          <p class="brandaiq-blog-excerpt"><?php echo esc_html(wp_trim_words(get_the_excerpt(), 26)); ?></p>
          <a class="brandaiq-link" href="<?php the_permalink(); ?>">Read more →</a>
        </div>
      </article>
    <?php endwhile; wp_reset_postdata(); else: ?>
      <p>No posts yet.</p>
    <?php endif; ?>
  </div>
  <div class="brandaiq-pagination">
    <?php echo paginate_links(['total'=>$q->max_num_pages,'current'=>$paged]); ?>
  </div>
  <?php
  return ob_get_clean();
}
add_shortcode('brandaiq_blog_index', 'brandaiq_blog_index_shortcode');
