<?php
if (!defined('ABSPATH')) exit;

function brandaiq_defaults(){
  return [
    // Company
    'name' => 'BrandAIQ Plumbing',
    // Attachment ID for header logo (uploaded via media library)
    'logo_id' => 0,
    'phone' => '+1 (555) 809-2011',
    'email' => 'support@example.com',
    'address' => '1703 Capital Ave, Plano, TX 75074',
    'hours' => 'Mon–Sat 8am–6pm • 24/7 Emergency',
    'service_areas' => 'Plano, Frisco, McKinney, Allen',
    'footer_tagline' => 'Fast, reliable plumbing service. Same-day appointments and 24/7 emergency support.',
    // Design
    'color_mode' => 'yellow_black',
    'header_phone' => '1',
    'floating_call' => '1',
    // Sections toggles
    'sec_hero' => '1',
    'sec_services' => '1',
    'sec_call_banner' => '1',
    'sec_info' => '1',
    'sec_why' => '1',
    'sec_team' => '0',
    'sec_testimonials' => '1',
    'sec_map' => '0',
    'sec_social' => '1',

    // Hero
    'hero_title' => 'Plumbers. We Get It Right.',
    'hero_subtitle' => 'Fast, reliable plumbing services with honest pricing. Same-day appointments available.',
    'hero_badge' => 'Emergency? Call now!',
    'hero_btn1_text' => 'Get Free Quote',
    'hero_btn1_url' => '/contact',
    'hero_btn2_text' => 'Call Now',
    'hero_btn2_url' => '',
    'hero_bg_id' => '',
    'hero_plumber_id' => '',

    // Hero slider
    'hero_use_slider' => '0',
    'hero_slider_autoplay' => '5000',
    'hero_slides' => wp_json_encode([
      [
        'image_id' => '',
        'title' => 'Plumbers. We Get It Right.',
        'subtitle' => 'Fast, reliable plumbing services with honest pricing. Same-day appointments available.',
        'badge' => 'Emergency? Call now!',
        'btn1_text' => 'Get Free Quote',
        'btn1_url' => '/contact',
        'btn2_text' => 'Call Now',
        'btn2_url' => ''
      ],
    ]),

    // Services (icon + title + text)
    'services' => wp_json_encode([
      ['icon'=>'dashicons-admin-tools','title'=>'Fixing Pipes','text'=>'Leaks, burst pipes, repipes, and emergency repairs.'],
      ['icon'=>'dashicons-admin-generic','title'=>'Water Heaters','text'=>'Install, repair, flush, and replace tank or tankless units.'],
      ['icon'=>'dashicons-shield','title'=>'Toilet Repair','text'=>'Clogs, leaks, seals, flushing issues, and replacements.'],
    ]),

    // Call banner
    'call_banner_title' => 'Need a plumber today?',
    'call_banner_text' => 'Call now for fast service and same-day appointments.',
    'call_banner_btn' => 'Call Now',

    // Info highlights
    'info_items' => wp_json_encode([
      ['title'=>'Same-Day Appointments','text'=>'We arrive on time and fix it fast.'],
      ['title'=>'Clean, Respectful Techs','text'=>'Shoe covers, cleanup, and clear explanations.'],
      ['title'=>'Work Guaranteed','text'=>'We stand behind our work and parts.'],
    ]),

    // Why choose us
    'why_items' => wp_json_encode([
      ['icon'=>'dashicons-awards','title'=>'Qualified Team','text'=>'Licensed, insured technicians with clean workmanship.'],
      ['icon'=>'dashicons-tag','title'=>'Affordable Pricing','text'=>'Up-front estimates and no surprise charges.'],
      ['icon'=>'dashicons-clock','title'=>'Quick Service','text'=>'Same-day appointments and fast response.'],
      ['icon'=>'dashicons-hammer','title'=>'Plumbing Experts','text'=>'Repairs, installs, and maintenance done right.'],
      ['icon'=>'dashicons-admin-home','title'=>'Installation Services','text'=>'Fixtures, water heaters, disposals, and more.'],
      ['icon'=>'dashicons-yes-alt','title'=>'100+ Projects Done','text'=>'Trusted by homeowners across the metro area.'],
    ]),

    // Team
    'team_items' => wp_json_encode([
      ['name'=>'Alex Turner','role'=>'Lead Technician','photo_id'=>''],
      ['name'=>'Maria Lopez','role'=>'Service Manager','photo_id'=>''],
      ['name'=>'Chris Johnson','role'=>'Technician','photo_id'=>''],
    ]),

    // Testimonials
    'testimonials_count' => '3',
    'testimonials' => wp_json_encode([
      ['quote'=>'Fast response and honest pricing. Fixed my leak the same day.','name'=>'Sarah M.'],
      ['quote'=>'Professional techs. Clean work, explained everything clearly.','name'=>'Daniel R.'],
      ['quote'=>'Great service for our water heater replacement. Highly recommend.','name'=>'Chris T.'],
      ['quote'=>'Quick scheduling and great communication.','name'=>'Maria L.'],
      ['quote'=>'They arrived on time and left everything clean.','name'=>'Chris P.'],
    ]),

    // Map + Social
    'map_embed' => '<iframe src="https://www.google.com/maps?q=Dallas%2C%20TX&output=embed" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>',
    'social_items' => wp_json_encode([
      ['label'=>'Facebook','url'=>'https://facebook.com/'],
      ['label'=>'Instagram','url'=>'https://instagram.com/'],
      ['label'=>'X','url'=>'https://x.com/'],
      ['label'=>'YouTube','url'=>'https://youtube.com/'],
    ]),
  ];
}

function brandaiq_opt2($key, $fallback=''){
  $opt = (array) get_option('brandaiq_company', []);
  $def = brandaiq_defaults();
  if (array_key_exists($key, $opt)) return $opt[$key];
  if (array_key_exists($key, $def)) return $def[$key];
  return $fallback;
}

function brandaiq_bool($key, $default='0'){
  return (string) brandaiq_opt2($key, $default) === '1';
}

function brandaiq_json_array($key){
  $raw = (string) brandaiq_opt2($key, '[]');
  $arr = json_decode($raw, true);
  return is_array($arr) ? $arr : [];
}

function brandaiq_tel_from_phone($phone){
  return preg_replace('/[^0-9\\+]/','', (string)$phone);
}

function brandaiq_btn($text, $url, $class='brandaiq-btn'){
  $text = trim((string)$text);
  if ($text === '') return '';
  $href = $url ? esc_url($url) : '';
  if ($href === '') return '';
  return '<a class="'.esc_attr($class).'" href="'.$href.'">'.esc_html($text).'</a>';
}

function brandaiq_section_head($kicker, $title, $text=''){
  ob_start(); ?>
  <div class="brandaiq-section-head">
    <?php if ($kicker): ?><div class="brandaiq-kicker"><?php echo esc_html($kicker); ?></div><?php endif; ?>
    <h2><?php echo esc_html($title); ?></h2>
    <?php if ($text): ?><p><?php echo esc_html($text); ?></p><?php endif; ?>
  </div>
  <?php return ob_get_clean();
}

function brandaiq_render_hero(){
  if (!brandaiq_bool('sec_hero','1')) return '';

  $use_slider = brandaiq_bool('hero_use_slider','0');
  $title = (string) brandaiq_opt2('hero_title');
  $sub = (string) brandaiq_opt2('hero_subtitle');
  $badge = (string) brandaiq_opt2('hero_badge');
  $btn1t = (string) brandaiq_opt2('hero_btn1_text'); $btn1u = (string) brandaiq_opt2('hero_btn1_url');
  $btn2t = (string) brandaiq_opt2('hero_btn2_text'); $btn2u = (string) brandaiq_opt2('hero_btn2_url');
  $phone = (string) brandaiq_opt2('phone');
  $tel = brandaiq_tel_from_phone($phone);

  $bg_id = absint(brandaiq_opt2('hero_bg_id','0'));
  $bg_url = $bg_id ? wp_get_attachment_image_url($bg_id,'full') : '';
  $pl_id = absint(brandaiq_opt2('hero_plumber_id','0'));
  $pl_url = $pl_id ? wp_get_attachment_image_url($pl_id,'large') : '';

  $style = $bg_url ? ' style="background-image:url('.esc_url($bg_url).')"' : '';
  $slides = $use_slider ? brandaiq_json_array('hero_slides') : [];
  $autoplay = (int) brandaiq_opt2('hero_slider_autoplay','5000');
  if ($autoplay < 2000) $autoplay = 2000;
  ob_start(); ?>

  <section class="brandaiq-hero"<?php echo (!$use_slider ? $style : ''); ?>>
    <?php if($use_slider && $slides): ?>
      <div class="brandaiq-hero-slider" data-autoplay="<?php echo esc_attr($autoplay); ?>">
        <div class="brandaiq-hero-slides">
          <?php foreach($slides as $idx=>$s):
            $sid = absint($s['image_id'] ?? 0);
            $surl = $sid ? wp_get_attachment_image_url($sid, 'full') : '';
            if (!$surl) $surl = $bg_url;
            $stitle = (string)($s['title'] ?? $title);
            $ssub = (string)($s['subtitle'] ?? $sub);
            $sbadge = (string)($s['badge'] ?? $badge);
            $sb1t = (string)($s['btn1_text'] ?? $btn1t);
            $sb1u = (string)($s['btn1_url'] ?? $btn1u);
            $sb2t = (string)($s['btn2_text'] ?? $btn2t);
          ?>
            <div class="brandaiq-hero-slide<?php echo $idx===0?' is-active':''; ?>" style="background-image:url(<?php echo esc_url($surl); ?>)">
              <div class="brandaiq-container brandaiq-hero__wrap">
                <div class="brandaiq-hero__card">
                  <?php if($sbadge): ?><div class="brandaiq-hero__badge"><?php echo esc_html($sbadge); ?> <a href="tel:<?php echo esc_attr($tel); ?>"><?php echo esc_html($phone); ?></a></div><?php endif; ?>
                  <h1><?php echo esc_html($stitle); ?></h1>
                  <p><?php echo esc_html($ssub); ?></p>
                  <div class="brandaiq-hero__actions">
                    <a class="brandaiq-btn" href="<?php echo esc_url(home_url($sb1u ?: '/contact')); ?>"><?php echo esc_html($sb1t ?: 'Get Free Quote'); ?></a>
                    <a class="brandaiq-btn brandaiq-btn--dark" href="tel:<?php echo esc_attr($tel); ?>"><?php echo esc_html($sb2t ?: 'Call Now'); ?></a>
                  </div>
                  <div class="brandaiq-hero__meta">Licensed • Insured • 24/7 Emergency</div>
                </div>
                <?php if($pl_url): ?>
                  <div class="brandaiq-hero__person"><img src="<?php echo esc_url($pl_url); ?>" alt="" loading="lazy"></div>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
        <button class="brandaiq-hero-arrow brandaiq-hero-arrow--prev" type="button" aria-label="Previous slide">‹</button>
        <button class="brandaiq-hero-arrow brandaiq-hero-arrow--next" type="button" aria-label="Next slide">›</button>
        <div class="brandaiq-hero-dots" aria-label="Hero slides"></div>
      </div>
    <?php else: ?>
      <div class="brandaiq-container brandaiq-hero__wrap">
        <div class="brandaiq-hero__card">
          <?php if($badge): ?><div class="brandaiq-hero__badge"><?php echo esc_html($badge); ?> <a href="tel:<?php echo esc_attr($tel); ?>"><?php echo esc_html($phone); ?></a></div><?php endif; ?>
          <h1><?php echo esc_html($title); ?></h1>
          <p><?php echo esc_html($sub); ?></p>
          <div class="brandaiq-hero__actions">
            <a class="brandaiq-btn" href="<?php echo esc_url(home_url($btn1u ?: '/contact')); ?>"><?php echo esc_html($btn1t ?: 'Get Free Quote'); ?></a>
            <a class="brandaiq-btn brandaiq-btn--dark" href="tel:<?php echo esc_attr($tel); ?>"><?php echo esc_html($btn2t ?: 'Call Now'); ?></a>
          </div>
          <div class="brandaiq-hero__meta">Licensed • Insured • 24/7 Emergency</div>
        </div>
        <?php if($pl_url): ?>
          <div class="brandaiq-hero__person"><img src="<?php echo esc_url($pl_url); ?>" alt="" loading="lazy"></div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_services(){
  if (!brandaiq_bool('sec_services','1')) return '';
  $items = brandaiq_json_array('services');
  if (!$items) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-services">
    <div class="brandaiq-container">
      <?php echo brandaiq_section_head('BEST SERVICES', 'Plumbing Is What We Do', ''); ?>
      <div class="brandaiq-services-grid">
        <?php foreach($items as $it):
          $icon = sanitize_html_class($it['icon'] ?? 'dashicons-admin-tools');
          $title = (string)($it['title'] ?? '');
          $text = (string)($it['text'] ?? '');
        ?>
        <div class="brandaiq-service-card">
          <div class="brandaiq-service-icon"><span class="dashicons <?php echo esc_attr($icon); ?>"></span></div>
          <h3><?php echo esc_html($title); ?></h3>
          <p><?php echo esc_html($text); ?></p>
        </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_call_banner(){
  if (!brandaiq_bool('sec_call_banner','1')) return '';
  $phone = (string) brandaiq_opt2('phone'); $tel = brandaiq_tel_from_phone($phone);
  if (!$tel) return '';
  $t = (string) brandaiq_opt2('call_banner_title');
  $x = (string) brandaiq_opt2('call_banner_text');
  $b = (string) brandaiq_opt2('call_banner_btn');
  ob_start(); ?>
  <section class="brandaiq-call-banner">
    <div class="brandaiq-container brandaiq-call-banner-inner">
      <div>
        <strong><?php echo esc_html($t ?: 'Need a plumber today?'); ?></strong>
        <span><?php echo esc_html($x ?: 'Call now for fast service and same-day appointments.'); ?></span>
      </div>
      <a class="brandaiq-btn brandaiq-btn--accent" href="tel:<?php echo esc_attr($tel); ?>"><?php echo esc_html($b ?: 'Call Now'); ?></a>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_info(){
  if (!brandaiq_bool('sec_info','1')) return '';
  $items = brandaiq_json_array('info_items');
  if (!$items) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-info">
    <div class="brandaiq-info-grid">
      <?php foreach($items as $it): ?>
        <div class="brandaiq-info-item">
          <h3><?php echo esc_html((string)($it['title'] ?? '')); ?></h3>
          <p><?php echo esc_html((string)($it['text'] ?? '')); ?></p>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_why(){
  if (!brandaiq_bool('sec_why','1')) return '';
  $items = brandaiq_json_array('why_items');
  if (!$items) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-why">
    <?php echo brandaiq_section_head('WHAT MAKES US UNIQUE', 'Why To Choose Our Services', ''); ?>
    <div class="brandaiq-why-grid">
      <?php foreach($items as $it):
        $icon = sanitize_html_class($it['icon'] ?? 'dashicons-awards');
      ?>
        <div class="brandaiq-why-item">
          <span class="dashicons <?php echo esc_attr($icon); ?>"></span>
          <div>
            <strong><?php echo esc_html((string)($it['title'] ?? '')); ?></strong>
            <p><?php echo esc_html((string)($it['text'] ?? '')); ?></p>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_team(){
  if (!brandaiq_bool('sec_team','0')) return '';
  $items = brandaiq_json_array('team_items');
  if (!$items) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-team">
    <?php echo brandaiq_section_head('', 'Meet Our Technicians', 'Friendly, experienced pros ready to help.'); ?>
    <div class="brandaiq-team-grid">
      <?php foreach($items as $m):
        $pid = absint($m['photo_id'] ?? 0);
        $url = $pid ? wp_get_attachment_image_url($pid,'medium') : '';
      ?>
        <div class="brandaiq-team-card">
          <div class="brandaiq-team-photo">
            <?php if($url): ?><img src="<?php echo esc_url($url); ?>" alt=""><?php else: ?><div class="brandaiq-team-ph"></div><?php endif; ?>
          </div>
          <div class="brandaiq-team-meta">
            <strong><?php echo esc_html((string)($m['name'] ?? '')); ?></strong>
            <span><?php echo esc_html((string)($m['role'] ?? '')); ?></span>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_testimonials(){
  if (!brandaiq_bool('sec_testimonials','1')) return '';
  $count = absint(brandaiq_opt2('testimonials_count','3'));
  if (!in_array($count,[3,5], true)) $count = 3;
  $items = brandaiq_json_array('testimonials');
  if (!$items) return '';
  $items = array_slice(array_values($items), 0, $count);
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-testimonials-sec">
    <?php echo brandaiq_section_head('', 'What Customers Say', 'Real homeowners. Real results.'); ?>
    <div class="brandaiq-testimonials">
      <?php foreach($items as $t): ?>
        <div class="brandaiq-tile">
          <p>“<?php echo esc_html((string)($t['quote'] ?? '')); ?>”</p>
          <p><strong>— <?php echo esc_html((string)($t['name'] ?? '')); ?></strong></p>
        </div>
      <?php endforeach; ?>
    </div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_map(){
  if (!brandaiq_bool('sec_map','0')) return '';
  $embed = (string) brandaiq_opt2('map_embed','');
  if (!$embed) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-map">
    <?php echo brandaiq_section_head('', 'Service Area Map', 'We serve nearby neighborhoods and surrounding cities.'); ?>
    <div class="brandaiq-map-embed"><?php echo $embed; ?></div>
  </section>
  <?php return ob_get_clean();
}

function brandaiq_render_social(){
  if (!brandaiq_bool('sec_social','1')) return '';
  $items = brandaiq_json_array('social_items');
  if (!$items) return '';
  ob_start(); ?>
  <section class="brandaiq-section brandaiq-social">
    <div class="brandaiq-social-row">
      <h3>Follow Us</h3>
      <div class="brandaiq-social-links">
        <?php foreach($items as $s):
          $label = (string)($s['label'] ?? '');
          $url = (string)($s['url'] ?? '');
          if(!$label || !$url) continue;
        ?>
          <a class="brandaiq-social-link" href="<?php echo esc_url($url); ?>" rel="noopener" target="_blank"><?php echo esc_html($label); ?></a>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
  <?php return ob_get_clean();
}
