<?php
if (!defined('ABSPATH')) exit;

add_action('wp_head', function(){
  $c = (array) get_option('brandaiq_company', []);
  if (empty($c['name'])) return;

  $schema = [
    '@context' => 'https://schema.org',
    '@type' => 'Plumber',
    'name' => $c['name'] ?? '',
    'telephone' => $c['phone'] ?? '',
    'email' => $c['email'] ?? '',
    'address' => $c['address'] ?? '',
    'openingHours' => $c['hours'] ?? ''
  ];

  echo "\n<script type=\"application/ld+json\">" . wp_json_encode($schema, JSON_UNESCAPED_SLASHES) . "</script>\n";
}, 20);
