<?php
// Demo page creation for BrandAIQ Plumber

if (!defined('ABSPATH')) exit;

function brandaiq_create_page_if_missing($title, $slug, $content){
  $existing = get_page_by_path($slug);
  if ($existing && $existing instanceof WP_Post) return $existing->ID;
  $id = wp_insert_post([
    'post_title'   => $title,
    'post_name'    => $slug,
    'post_content' => $content,
    'post_status'  => 'publish',
    'post_type'    => 'page'
  ]);
  return is_wp_error($id) ? 0 : (int)$id;
}

function brandaiq_setup_demo_pages(){
  if (get_option('brandaiq_demo_pages_done')) return;

  // Home uses front-page.php when set as static front page.
  $home_id = brandaiq_create_page_if_missing(
    'Home',
    'home',
    "<!-- This page is rendered by the BrandAIQ front-page template. -->"
  );

  $services_id = brandaiq_create_page_if_missing(
    'Services',
    'services',
    "<h2>Professional Plumbing Services</h2>\n<p>We handle residential and commercial plumbing with fast response times and honest pricing.</p>\n<h3>Popular Services</h3>\n<ul>\n<li>Drain cleaning & clog removal</li>\n<li>Water heater installation & repair</li>\n<li>Leak detection & pipe repair</li>\n<li>Toilet, faucet, and fixture service</li>\n<li>Emergency plumbing (24/7)</li>\n</ul>\n<p><a class=\"brandaiq-btn brandaiq-btn--dark\" href=\"/contact\">Request a Quote</a></p>"
  );

  $about_id = brandaiq_create_page_if_missing(
    'About',
    'about',
    "<h2>About Our Company</h2>\n<p>We’re a local plumbing team focused on quality workmanship, clear communication, and reliable service.</p>\n<div class=\"brandaiq-two-col\">\n<div class=\"brandaiq-tile\"><h3>Our Mission</h3><p>Provide stress-free plumbing service with upfront pricing and professional technicians.</p></div>\n<div class=\"brandaiq-tile\"><h3>Why Customers Trust Us</h3><ul class=\"brandaiq-bullets\"><li>Licensed & insured</li><li>Same-day appointments</li><li>Respectful, clean technicians</li><li>Work guaranteed</li></ul></div>\n</div>"
  );

  $contact_id = brandaiq_create_page_if_missing(
    'Contact',
    'contact',
    "<h2>Contact Us</h2>\n<p>Tell us what you need and we’ll get back to you quickly.</p>\n[brandaiq_contact_form]"
  );

  if ($home_id) {
    update_option('show_on_front', 'page');
    update_option('page_on_front', $home_id);
  }

  // Create & assign primary menu
  if (!wp_get_nav_menu_object('BrandAIQ Primary')) {
    $menu_id = wp_create_nav_menu('BrandAIQ Primary');
    if ($menu_id && !is_wp_error($menu_id)) {
      $items = [
        ['title'=>'Home', 'id'=>$home_id],
        ['title'=>'Services', 'id'=>$services_id],
        ['title'=>'About', 'id'=>$about_id],
        ['title'=>'Contact', 'id'=>$contact_id],
      ];
      foreach ($items as $it){
        if (!$it['id']) continue;
        wp_update_nav_menu_item($menu_id, 0, [
          'menu-item-title' => $it['title'],
          'menu-item-object' => 'page',
          'menu-item-object-id' => $it['id'],
          'menu-item-type' => 'post_type',
          'menu-item-status' => 'publish'
        ]);
      }
      $locations = get_theme_mod('nav_menu_locations');
      if (!is_array($locations)) $locations = [];
      $locations['primary'] = $menu_id;
      set_theme_mod('nav_menu_locations', $locations);
    }
  }

  update_option('brandaiq_demo_pages_done', 1);
}
