<?php
$opt = (array) get_option('brandaiq_company', []);
$show_phone = (($opt['header_phone'] ?? '1') === '1');
$phone = $opt['phone'] ?? '';
$tel = preg_replace('/[^0-9\+]/','', $phone);
$logo_id = (int)($opt['logo_id'] ?? 0);
$logo_url = $logo_id ? wp_get_attachment_image_url($logo_id,'full') : '';
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo('charset'); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header class="brandaiq-header">
  <div class="brandaiq-container brandaiq-header-inner">
    <div class="brandaiq-logo">
      <a class="brandaiq-brand-link" href="<?php echo esc_url(home_url('/')); ?>" aria-label="<?php echo esc_attr($opt['name'] ?? get_bloginfo('name')); ?>">
        <?php if (!empty($logo_url)): ?>
          <img class="brandaiq-logo-img" src="<?php echo esc_url($logo_url); ?>" alt="<?php echo esc_attr($opt['name'] ?? get_bloginfo('name')); ?>" loading="lazy" decoding="async">
        <?php else: ?>
          <span class="brandaiq-brand-text"><?php echo esc_html($opt['name'] ?? get_bloginfo('name')); ?></span>
        <?php endif; ?>
      </a>
    </div>

    <button class="brandaiq-burger" aria-label="Menu" aria-expanded="false">
      <span></span><span></span><span></span>
    </button>

    <nav class="brandaiq-nav" aria-label="Primary">
      <?php
      wp_nav_menu([
        'theme_location' => 'primary',
        'container' => false,
        'menu_class' => 'brandaiq-menu',
        'fallback_cb' => '__return_false'
      ]);
      ?>
    </nav>

    <?php if ($show_phone && !empty($phone)): ?>
    <div class="brandaiq-topcta">
      <a class="brandaiq-phone" href="tel:<?php echo esc_attr($tel); ?>">
        <?php echo esc_html($phone); ?>
      </a>
    </div>
    <?php endif; ?>
  </div>
</header>
<main class="brandaiq-main">
