<?php
if (!defined('ABSPATH')) exit;

// Core includes
require_once get_theme_file_path('inc/company-settings.php'); // includes section-engine.php
require_once get_theme_file_path('inc/schema.php');
require_once get_theme_file_path('inc/shortcodes.php');
require_once get_theme_file_path('inc/demo-pages.php');

// Create demo pages on first theme activation.
add_action('after_switch_theme', function(){
  if (function_exists('brandaiq_setup_demo_pages')) {
    brandaiq_setup_demo_pages();
  }
});

add_action('after_setup_theme', function () {
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
  add_theme_support('responsive-embeds');
  add_theme_support('custom-logo');

  register_nav_menus([
    'primary' => __('Primary Menu', 'brandaiq'),
  ]);
});

add_action('wp_enqueue_scripts', function () {
  $ver = wp_get_theme()->get('Version');
  wp_enqueue_style('dashicons');
  wp_enqueue_style('brandaiq-main', get_theme_file_uri('assets/css/main.css'), [], $ver);
  wp_enqueue_script('brandaiq-main', get_theme_file_uri('assets/js/main.js'), [], $ver, true);
});

add_filter('body_class', function ($classes) {
  $mode = brandaiq_opt2('color_mode', 'yellow_black');
  $map = [
    'yellow_black' => 'brandaiq-mode-yellow',
    'navy_aqua'    => 'brandaiq-mode-navy',
    'blue_orange'  => 'brandaiq-mode-blue_orange',
    'green_navy'   => 'brandaiq-mode-green_navy',
    'red_black'    => 'brandaiq-mode-red_black',
  ];
  $classes[] = $map[$mode] ?? 'brandaiq-mode-yellow';
  return $classes;
});

// Floating Call button
add_action('wp_footer', function () {
  $phone = brandaiq_opt2('phone', '');
  if (!$phone) return;
  if (brandaiq_opt2('floating_call', '1') !== '1') return;

  $tel = preg_replace('/[^0-9\+]/', '', $phone);
  if (!$tel) return;

  echo '<a class="brandaiq-call" href="tel:' . esc_attr($tel) . '"><span class="dashicons dashicons-phone"></span> Call Now</a>';
}, 30);

// Optional Helpisto widget (ONLY if enabled)
add_action('wp_footer', function () {
  if (brandaiq_opt2('helpisto_enabled', '0') !== '1') return;

  $id = (string) brandaiq_opt2('helpisto_widget_id', '');
  $id = preg_replace('/[^a-zA-Z0-9\-]/', '', $id);
  if (!$id) return;

  echo "\n<!-- Helpisto Widget (optional) -->\n";
  echo '<script src="https://helpisto.com/widget/helpisto-chat.js" data-helpisto-id="' . esc_attr($id) . '"></script>' . "\n";
}, 99);
