(function(){
  const btn = document.querySelector('.brandaiq-burger');
  const nav = document.querySelector('.brandaiq-nav');
  if(!btn || !nav) return;
  btn.addEventListener('click', function(){
    const open = nav.classList.toggle('is-open');
    btn.setAttribute('aria-expanded', open ? 'true' : 'false');
  });
})();

(function(){
  const slider = document.querySelector('.brandaiq-hero-slider');
  if (!slider) return;
  const slides = Array.from(slider.querySelectorAll('.brandaiq-hero-slide'));
  if (slides.length <= 1) return;

  const dots = Array.from(slider.querySelectorAll('.brandaiq-hero-dot'));
  const prev = slider.querySelector('.brandaiq-hero-prev');
  const next = slider.querySelector('.brandaiq-hero-next');
  const autoplay = parseInt(slider.getAttribute('data-autoplay') || '0', 10);
  let idx = 0;
  let timer = null;

  function show(i){
    idx = (i + slides.length) % slides.length;
    slides.forEach((s, k) => s.classList.toggle('is-active', k===idx));
    dots.forEach((d, k) => d.classList.toggle('is-active', k===idx));
  }

  function start(){
    if (!autoplay || autoplay < 1500) return;
    stop();
    timer = setInterval(() => show(idx+1), autoplay);
  }

  function stop(){
    if (timer) clearInterval(timer);
    timer = null;
  }

  if (prev) prev.addEventListener('click', (e)=>{ e.preventDefault(); show(idx-1); start(); });
  if (next) next.addEventListener('click', (e)=>{ e.preventDefault(); show(idx+1); start(); });
  dots.forEach((d, k) => d.addEventListener('click', (e)=>{ e.preventDefault(); show(k); start(); }));
  slider.addEventListener('mouseenter', stop);
  slider.addEventListener('mouseleave', start);

  show(0);
  start();
})();
