
(function($){
  // Tabs
  function showTab(key){
    $('.brandaiq-tab').removeClass('is-active');
    $('.brandaiq-panel').removeClass('is-active');
    $('.brandaiq-tab[data-tab="'+key+'"]').addClass('is-active');
    $('.brandaiq-panel[data-panel="'+key+'"]').addClass('is-active');
    localStorage.setItem('brandaiq_tab', key);
  }
  $(document).on('click', '.brandaiq-tab', function(){
    showTab($(this).data('tab'));
  });
  $(function(){

  function brandaiqInitColors(ctx){
    if (typeof jQuery.fn.wpColorPicker !== 'function') return;
    jQuery(ctx||document).find('input.brandaiq-color').each(function(){
      var $i=jQuery(this);
      if ($i.data('wpColorPicker')) return;
      $i.wpColorPicker();
    });
  }
  brandaiqInitColors(document);
    showTab(localStorage.getItem('brandaiq_tab') || 'company');
  });

  function parseJSON(v){ try { var a=JSON.parse(v||'[]'); return Array.isArray(a)?a:[]; } catch(e){ return []; } }
  function saveJSON($store, arr){ $store.val(JSON.stringify(arr)); }

  function makeBuilder(storeSel, wrapSel, addSel, templateFn, readFn, addDefault){
    var $store=$(storeSel), $wrap=$(wrapSel), $add=$(addSel);
    if(!$store.length||!$wrap.length) return;

    function render(){
      var list=parseJSON($store.val());
      $wrap.empty();
      list.forEach(function(it, idx){ $wrap.append(templateFn(it, idx)); });
    }
    function sync(){
      var list=[];
      $wrap.find('.brandaiq-item').each(function(){ list.push(readFn($(this))); });
      saveJSON($store, list);
    }
    $wrap.on('input change', 'input,textarea,select', function(){ sync(); });
    $wrap.on('click', '.brandaiq-remove', function(e){
      e.preventDefault();
      var idx=$(this).closest('.brandaiq-item').data('idx');
      var list=parseJSON($store.val());
      list.splice(idx,1);
      saveJSON($store, list);
      render();
    });
    if($add.length){
      $add.on('click', function(e){
        e.preventDefault();
        var list=parseJSON($store.val());
        list.push(addDefault());
        saveJSON($store, list);
        render();
      });
    }
    render();
  }

  // Services
  makeBuilder('#brandaiq_services_json','#brandaiq_services_builder','#brandaiq_add_service',
    function(it, idx){
      return $('<div class="brandaiq-item" data-idx="'+idx+'">\
        <div class="row"><strong>Service</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
        <label>Icon (Dashicons class)<input class="icon" value="'+(it.icon||'dashicons-admin-tools')+'"></label>\
        <label>Title<input class="t" value="'+(it.title||'')+'"></label>\
        <label>Description<textarea class="x" rows="2">'+(it.text||'')+'</textarea></label>\
      </div>');
    },
    function($c){ return {icon:$c.find('.icon').val(), title:$c.find('.t').val(), text:$c.find('.x').val()}; },
    function(){ return {icon:'dashicons-admin-tools', title:'New Service', text:'Describe this service.'}; }
  );

  // Why
  makeBuilder('#brandaiq_why_json','#brandaiq_why_builder','#brandaiq_add_why',
    function(it, idx){
      return $('<div class="brandaiq-item" data-idx="'+idx+'">\
        <div class="row"><strong>Item</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
        <label>Icon (Dashicons class)<input class="icon" value="'+(it.icon||'dashicons-awards')+'"></label>\
        <label>Title<input class="t" value="'+(it.title||'')+'"></label>\
        <label>Text<textarea class="x" rows="2">'+(it.text||'')+'</textarea></label>\
      </div>');
    },
    function($c){ return {icon:$c.find('.icon').val(), title:$c.find('.t').val(), text:$c.find('.x').val()}; },
    function(){ return {icon:'dashicons-awards', title:'New Reason', text:'Explain why customers choose you.'}; }
  );

  // Info
  makeBuilder('#brandaiq_info_json','#brandaiq_info_builder','#brandaiq_add_info',
    function(it, idx){
      return $('<div class="brandaiq-item" data-idx="'+idx+'">\
        <div class="row"><strong>Info</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
        <label>Title<input class="t" value="'+(it.title||'')+'"></label>\
        <label>Text<textarea class="x" rows="2">'+(it.text||'')+'</textarea></label>\
      </div>');
    },
    function($c){ return {title:$c.find('.t').val(), text:$c.find('.x').val()}; },
    function(){ return {title:'New Highlight', text:'Short benefit statement.'}; }
  );

  // Testimonials
  makeBuilder('#brandaiq_testimonials_json','#brandaiq_testimonials_builder','#brandaiq_add_testimonial',
    function(it, idx){
      return $('<div class="brandaiq-item" data-idx="'+idx+'">\
        <div class="row"><strong>Testimonial</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
        <label>Quote<textarea class="q" rows="2">'+(it.quote||'')+'</textarea></label>\
        <label>Name<input class="n" value="'+(it.name||'')+'"></label>\
      </div>');
    },
    function($c){ return {quote:$c.find('.q').val(), name:$c.find('.n').val()}; },
    function(){ return {quote:'Great service and quick response.', name:'Customer'}; }
  );

  // Social
  makeBuilder('#brandaiq_social_json','#brandaiq_social_builder','#brandaiq_add_social',
    function(it, idx){
      return $('<div class="brandaiq-item" data-idx="'+idx+'">\
        <div class="row"><strong>Social</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
        <label>Label<input class="l" value="'+(it.label||'')+'"></label>\
        <label>URL<input class="u" value="'+(it.url||'')+'"></label>\
      </div>');
    },
    function($c){ return {label:$c.find('.l').val(), url:$c.find('.u').val()}; },
    function(){ return {label:'Facebook', url:'https://facebook.com/'}; }
  );

  // Team (media)
  (function(){
    var $store=$('#brandaiq_team_json'), $wrap=$('#brandaiq_team_builder'), $add=$('#brandaiq_add_team');
    if(!$store.length||!$wrap.length) return;
    function render(){
      var list=parseJSON($store.val());
      $wrap.empty();
      list.forEach(function(it, idx){
        var photo = it.photo_url ? '<img src="'+it.photo_url+'">' : '';
        $wrap.append($('<div class="brandaiq-item" data-idx="'+idx+'">\
          <div class="row"><strong>Member</strong><a href="#" class="brandaiq-remove">Remove</a></div>\
          <div class="brandaiq-team-row">\
            <div class="brandaiq-photo">'+photo+'</div>\
            <div>\
              <label>Name<input class="n" value="'+(it.name||'')+'"></label>\
              <label>Role<input class="r" value="'+(it.role||'')+'"></label>\
              <input type="hidden" class="pid" value="'+(it.photo_id||'')+'">\
              <input type="hidden" class="purl" value="'+(it.photo_url||'')+'">\
              <button type="button" class="button team-pick">Choose Photo</button>\
              <button type="button" class="button team-clear">Remove Photo</button>\
            </div>\
          </div>\
        </div>'));
      });
    }
    function sync(){
      var list=[];
      $wrap.find('.brandaiq-item').each(function(){
        var $c=$(this);
        list.push({name:$c.find('.n').val(), role:$c.find('.r').val(), photo_id:$c.find('.pid').val(), photo_url:$c.find('.purl').val()});
      });
      saveJSON($store, list);
    }
    $wrap.on('input change', 'input,textarea', function(){ sync(); });
    $wrap.on('click', '.brandaiq-remove', function(e){
      e.preventDefault();
      var idx=$(this).closest('.brandaiq-item').data('idx');
      var list=parseJSON($store.val());
      list.splice(idx,1);
      saveJSON($store, list);
      render();
    });
    $wrap.on('click', '.team-clear', function(e){
      e.preventDefault();
      var $c=$(this).closest('.brandaiq-item');
      $c.find('.pid').val(''); $c.find('.purl').val('');
      sync(); render();
    });
    $wrap.on('click', '.team-pick', function(e){
      e.preventDefault();
      var $c=$(this).closest('.brandaiq-item');
      var frame = wp.media({ title:'Select team photo', button:{text:'Use this photo'}, multiple:false });
      frame.on('select', function(){
        var att = frame.state().get('selection').first().toJSON();
        $c.find('.pid').val(att.id);
        $c.find('.purl').val(att.url);
        sync(); render();
      });
      frame.open();
    });
    $add.on('click', function(e){
      e.preventDefault();
      var list=parseJSON($store.val());
      list.push({name:'New Member', role:'Technician', photo_id:'', photo_url:''});
      saveJSON($store, list);
      render();
    });
    render();
  })();

  // Hero slider builder (background slides)
  (function(){
    var $wrap = $('#brandaiq-hero-slides');
    var $store = $('#brandaiq_hero_slides_json');
    if (!$wrap.length || !$store.length) return;

    function defaultSlides(){
      return [
        {
          image_id:'',
          image_url:'',
          title: $('input[name="brandaiq_company[hero_title]"]').val() || 'Plumbers. We Get It Right.',
          subtitle: $('textarea[name="brandaiq_company[hero_subtitle]"]').val() || 'Fast, reliable plumbing services with honest pricing. Same-day appointments available.',
          badge: $('input[name="brandaiq_company[hero_badge]"]').val() || 'Emergency? Call now!',
          btn1_text: $('input[name="brandaiq_company[hero_btn1_text]"]').val() || 'Get Free Quote',
          btn1_url: $('input[name="brandaiq_company[hero_btn1_url]"]').val() || '/contact',
          btn2_text: $('input[name="brandaiq_company[hero_btn2_text]"]').val() || 'Call Now',
          btn2_url: ''
        }
      ];
    }

    function renderPreview(){
      var box = $('#brandaiq_hero_preview_box');
      if (!box.length) return;
      var slides = parseJSON($store.val());
      if (!slides.length) slides = defaultSlides();
      var s = slides[0];
      var bgUrl = s.image_url;
      if (!bgUrl){
        var bgimg = $('#brandaiq_bg_preview img').attr('src');
        if (bgimg) bgUrl = bgimg;
      }
      box.css('backgroundImage', bgUrl ? 'url('+bgUrl+')' : 'none');
      box.find('.brandaiq-hero-preview-badge').text(s.badge || '');
      box.find('.brandaiq-hero-preview-title').text(s.title || '');
      box.find('.brandaiq-hero-preview-sub').text(s.subtitle || '');

      var pl = $('#brandaiq_plumber_preview img').attr('src');
      var $person = $('#brandaiq_hero_preview_person');
      if ($person.length){
        $person.html(pl ? '<img src="'+pl+'" alt="" />' : '');
      }
    }

    function slideRow(slide, idx){
      return [
        '<div class="brandaiq-repeater-row" data-idx="', idx, '">',
          '<div class="brandaiq-repeater-head">Slide ', (idx+1), ' <a href="#" class="brandaiq-remove" data-act="remove">Remove</a></div>',
          '<div class="brandaiq-grid">',
            '<div class="brandaiq-span2">',
              '<label>Slide Background Image <span class="brandaiq-muted">(recommended 1600×700+)</span>',
                '<input type="hidden" class="slide-image-id" value="', esc(slide.image_id), '">',
                '<div class="brandaiq-media-actions">',
                  '<button type="button" class="button" data-act="pick">Choose Image</button>',
                  '<button type="button" class="button" data-act="clear">Remove</button>',
                '</div>',
                '<div class="brandaiq-preview">', (slide.image_url ? ('<img src="'+esc(slide.image_url)+'" alt="" />') : ''), '</div>',
              '</label>',
            '</div>',
            '<label class="brandaiq-span2">Title<input class="slide-title" value="', esc(slide.title), '"></label>',
            '<label class="brandaiq-span2">Subtitle<textarea class="slide-sub" rows="2">', esc(slide.subtitle), '</textarea></label>',
            '<label class="brandaiq-span2">Top Badge Text<input class="slide-badge" value="', esc(slide.badge), '"></label>',
            '<label>Button 1 Text<input class="slide-b1t" value="', esc(slide.btn1_text), '"></label>',
            '<label>Button 1 URL<input class="slide-b1u" value="', esc(slide.btn1_url), '"></label>',
            '<label>Extra Button Text (optional)<input class="slide-b2t" value="', esc(slide.btn2_text), '"></label>',
            '<label>Extra Button URL (optional)<input class="slide-b2u" value="', esc(slide.btn2_url), '"></label>',
          '</div>',
        '</div>'
      ].join('');
    }

    function esc(s){
      s = (s===undefined || s===null) ? '' : String(s);
      return s.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;');
    }

    function collect(){
      var slides = [];
      $wrap.find('.brandaiq-repeater-row').each(function(){
        var $r=$(this);
        slides.push({
          image_id: $r.find('.slide-image-id').val() || '',
          image_url: $r.find('.brandaiq-preview img').attr('src') || '',
          title: $r.find('.slide-title').val() || '',
          subtitle: $r.find('.slide-sub').val() || '',
          badge: $r.find('.slide-badge').val() || '',
          btn1_text: $r.find('.slide-b1t').val() || '',
          btn1_url: $r.find('.slide-b1u').val() || '',
          btn2_text: $r.find('.slide-b2t').val() || '',
          btn2_url: $r.find('.slide-b2u').val() || ''
        });
      });
      return slides;
    }

    function save(){
      var slides = collect();
      saveJSON($store, slides);
      renderPreview();
    }

    function render(){
      var slides = parseJSON($store.val());
      if (!slides.length) slides = defaultSlides();
      var html = '';
      slides.forEach(function(s, i){ html += slideRow(s, i); });
      $wrap.html(html);
      renderPreview();
    }

    $wrap.on('click', '[data-act="remove"]', function(e){
      e.preventDefault();
      $(this).closest('.brandaiq-repeater-row').remove();
      save();
    });

    $wrap.on('click', '[data-act="pick"]', function(e){
      e.preventDefault();
      var $row = $(this).closest('.brandaiq-repeater-row');
      var frame = wp.media({ title:'Select slide image', button:{text:'Use this image'}, multiple:false });
      frame.on('select', function(){
        var att = frame.state().get('selection').first().toJSON();
        $row.find('.slide-image-id').val(att.id);
        $row.find('.brandaiq-preview').html('<img src="'+att.url+'" alt="" />');
        save();
      });
      frame.open();
    });

    $wrap.on('click', '[data-act="clear"]', function(e){
      e.preventDefault();
      var $row = $(this).closest('.brandaiq-repeater-row');
      $row.find('.slide-image-id').val('');
      $row.find('.brandaiq-preview').empty();
      save();
    });

    $wrap.on('input change', 'input, textarea', function(){ save(); });

    $('#brandaiq_add_slide').on('click', function(e){
      e.preventDefault();
      var slides = parseJSON($store.val());
      slides.push({image_id:'', image_url:'', title:'', subtitle:'', badge:'', btn1_text:'', btn1_url:'', btn2_text:'', btn2_url:''});
      saveJSON($store, slides);
      render();
    });

    $('#brandaiq_reset_slides').on('click', function(e){
      e.preventDefault();
      saveJSON($store, defaultSlides());
      render();
    });

    render();
  })();

  // Hero media (preview without AJAX)
  function pickMedia(btnSel, idSel, previewSel){
    $(btnSel).on('click', function(e){
      e.preventDefault();
      var frame = wp.media({ title:'Select image', button:{text:'Use this image'}, multiple:false });
      frame.on('select', function(){
        var att = frame.state().get('selection').first().toJSON();
        $(idSel).val(att.id);
        $(previewSel).html('<img src="'+att.url+'">');
      });
      frame.open();
    });
  }
  function clearMedia(btnSel, idSel, previewSel){
    $(btnSel).on('click', function(e){
      e.preventDefault();
      $(idSel).val('');
      $(previewSel).empty();
    });
  }
  $(function(){
    // Company logo
    pickMedia('.brandaiq-pick-logo','#brandaiq_logo_id','#brandaiq_logo_preview');
    clearMedia('.brandaiq-clear-logo','#brandaiq_logo_id','#brandaiq_logo_preview');

    pickMedia('#brandaiq_pick_bg','#brandaiq_hero_bg_id','#brandaiq_bg_preview');
    clearMedia('#brandaiq_clear_bg','#brandaiq_hero_bg_id','#brandaiq_bg_preview');
    pickMedia('#brandaiq_pick_plumber','#brandaiq_hero_plumber_id','#brandaiq_plumber_preview');
    clearMedia('#brandaiq_clear_plumber','#brandaiq_hero_plumber_id','#brandaiq_plumber_preview');
  });
})(jQuery);